<?php
/**
*********************************************************************
* Copyright (c) 2009, 金山软件有限公司 All rights reserved.
*
* 文件名称： TcsqlClass.php
* 摘        要： TCSQL高并发数据库的PHP客户端类
* 描        述：
* 作        者： 张宴
* 部        门： 金山网络游戏子公司.逍遥网.技术支持部平台组
* 邮        箱： zhangyan2@kingsoft.com
* 版        本： 1.0
* 时        间： 2009-09-11
* 使用示例：
* $tcsql = new Tcsql();
* $result = $tcsql->insert($server_host, $server_port, $array_data, $pkey_alias);
*********************************************************************
*/
class Tcsql
{
	/*********************************************
	* 函数名：insert($server_host, $server_port, $array_data, $pkey_alias)
	* 函数用途：插入数据到TCSQL数据库
	* 创建时间：2009-09-11
	* 创建人：张宴
	* 参数说明：
	*    $server_host   TCSQL数据库服务器地址
	*    $server_port   TCSQL数据库服务器端口	
	*    $array_data   为数组，其中pkey为主键名词，不能变。array("pkey" => "", 字段名1 => "字段内容1",  字段名2 =>  123456);
	*    $pkey_alias   主键pkey的别名，如果你不想使用pkey作为主键名称，可以设置别名，以该别名作为主键名称。默认值为空，表示无别名。
	* 返回值（JSON串，第一位位状态码，1表示成功，0表示失败）：
	*    {"code":1,"introduction":"数据插入数据库成功。"}
	*********************************************/
    function insert($server_host, $server_port, $array_data, $pkey_alias)
    {
		/* pkey别名的值转换成pkey */
		if ($pkey_alias != "" && $array_data[$pkey_alias] != "") {
			$array_data['pkey'] = $array_data[$pkey_alias];
			unset($array_data[$pkey_alias]);
		}
	
		$data = json_encode($array_data);
		$url = "http://".$server_host.":".$server_port."/?command=insert";
		$opts = array(
			'http'=>array(
				'method'=>"POST",
				'header'=>"Content-type: application/x-www-form-urlencoded\r\n".
					"Content-length:".strlen($data)."\r\n" .
					"Cookie: foo=bar\r\n" .
					"\r\n",
				'content' => $data,
			)
		);
		$context = stream_context_create($opts);
		$result = file_get_contents($url, false, $context);
		return json_decode($result,true);	
	}
	
	/*********************************************
	* 函数名：update($server_host, $server_port, $array_data, $command, $pkey_alias)
	* 函数用途：更新数据到TCSQL数据库
	* 创建时间：2009-09-11
	* 创建人：张宴
	* 参数说明：
	*    $server_host   TCSQL数据库服务器地址
	*    $server_port   TCSQL数据库服务器端口	
	*    $array_data   为数组，其中pkey为主键名词，不能变。array("pkey" => "", 字段名1 => "字段内容1",  字段名2 =>  123456);
	*    $command   为查询条件，用来找出需要替换的记录主键。其中http://ip:port/?command=update&已经默认添加，您只需填写之后的URL内容，例如：where=pkey:NUMGE:100
	*    $pkey_alias   主键pkey的别名，如果你不想使用pkey作为主键名称，可以设置别名，以该别名作为主键名称。默认值为空，表示无别名。
	* 返回值（JSON串，第一位位状态码，1表示成功，0表示失败）：
	*    {"code":1,"introduction":"数据更新成功，影响列数：5"}
	*********************************************/
    function update($server_host, $server_port, $array_data, $command, $pkey_alias)
    {
		/* pkey别名的值转换成pkey */
		if ($pkey_alias != "" && $array_data[$pkey_alias] != "") {
			$array_data['pkey'] = $array_data[$pkey_alias];
			unset($array_data[$pkey_alias]);
		}

		/* 命令中的pkey别名的值转换成pkey */
		if ($pkey_alias != "") {
			$command = str_ireplace($pkey_alias.":", "pkey:", $command);
			$command = str_ireplace("order_filed=".$pkey_alias, "order_filed=pkey", $command);
		}
	
		$data = json_encode($array_data);
		$url = "http://".$server_host.":".$server_port."/?command=update&".$command;
		$opts = array(
			'http'=>array(
				'method'=>"POST",
				'header'=>"Content-type: application/x-www-form-urlencoded\r\n".
					"Content-length:".strlen($data)."\r\n" .
					"Cookie: foo=bar\r\n" .
					"\r\n",
				'content' => $data,
			)
		);
		$context = stream_context_create($opts);
		$result = file_get_contents($url, false, $context);
		return json_decode($result, true);
	}
	
	/*********************************************
	* 函数名：select($server_host, $server_port, $command, $pkey_alias)
	* 函数用途：查询TCSQL数据库
	* 创建时间：2009-09-11
	* 创建人：张宴
	* 参数说明：
	*    $server_host   TCSQL数据库服务器地址
	*    $server_port   TCSQL数据库服务器端口
	*    $command   为查询命令，其中http://ip:port/?command=select&已经默认添加，您只需填写之后的URL内容，例如：where=pkey:NUMGE:0|title:STRINC:keyword&order_filed=pkey&order_sort=NUMDESC&limit_skip=0&limit_max=10
	*    $pkey_alias   主键pkey的别名，如果你不想使用pkey作为主键名称，可以设置别名，以该别名作为主键名称。默认值为空，表示无别名。
	* 返回值（JSON串，json_decode解码后为二维数组）。
	*********************************************/
    function select($server_host, $server_port, $command, $pkey_alias)
    {
		/* 命令中的pkey别名的值转换成pkey */
		if ($pkey_alias != "") {
			$command = str_ireplace($pkey_alias.":", "pkey:", $command);
			$command = str_ireplace("order_filed=".$pkey_alias, "order_filed=pkey", $command);
		}	

		$url = "http://".$server_host.":".$server_port."/?command=select&".$command;
		$result = file_get_contents($url);
		$array_data = json_decode($result, true);
		
		/* pkey别名的值转换成pkey */
		if ($array_data != "") {
			foreach ($array_data as $array_data_key => $array_data_row) {
				if ($pkey_alias != "" && $array_data_row['pkey'] != "") {
					$array_data[$array_data_key][$pkey_alias] = $array_data_row['pkey'];
					unset($array_data[$array_data_key]['pkey']);
				}
			}
		}
		
		return $array_data;
	}
	
	/*********************************************
	* 函数名：delete($server_host, $server_port, $command, $pkey_alias)
	* 函数用途：删除TCSQL数据库的指定数据
	* 创建时间：2009-09-11
	* 创建人：张宴
	* 参数说明：
	*    $server_host   TCSQL数据库服务器地址
	*    $server_port   TCSQL数据库服务器端口
	*    $command   为查询命令，用来找出需要删除的记录。其中http://ip:port/?command=delete&已经默认添加，您只需填写之后的URL内容，例如：where=pkey:NUMGE:200|title:STRINC:keyword
	*    $pkey_alias   主键pkey的别名，如果你不想使用pkey作为主键名称，可以设置别名，以该别名作为主键名称。默认值为空，表示无别名。
	* 返回值（JSON串，第一位位状态码，1表示成功，0表示失败）：
	*    {"code":1,"introduction":"数据删除成功。"}
	*********************************************/
    function delete($server_host, $server_port, $command, $pkey_alias)
    {
		/* 命令中的pkey别名的值转换成pkey */
		if ($pkey_alias != "") {
			$command = str_ireplace($pkey_alias.":", "pkey:", $command);
			$command = str_ireplace("order_filed=".$pkey_alias, "order_filed=pkey", $command);
		}	
	
		$data = json_encode($array_data);
		$url = "http://".$server_host.":".$server_port."/?command=delete&".$command;
		$result = file_get_contents($url);
		return json_decode($result,true);
	}
	
	/*********************************************
	* 函数名：setindex($server_host, $server_port, $type, $filed)
	* 函数用途：插入数据到TCSQL数据库
	* 创建时间：2009-09-11
	* 创建人：张宴
	* 参数说明：
	*    $server_host   TCSQL数据库服务器地址
	*    $server_port   TCSQL数据库服务器端口
	*    $type   操作类型。TDBITLEXICAL：创建文本型索引，TDBITDECIMAL：创建数值型索引，TDBITTOKEN：创建标记倒排索引，TDBITQGRAM：创建q-gram倒排索引，TDBITOPT：优化索引，TDBITVOID：删除索引
	*    $pkey_alias   主键pkey的别名，如果你不想使用pkey作为主键名称，可以设置别名，以该别名作为主键名称。默认值为空，表示无别名。
	* 返回值（JSON串，第一位位状态码，1表示成功，0表示失败）：
	*   {"code":1,"introduction":"索引设置成功。"}
	*********************************************/
    function setindex($server_host, $server_port, $type, $filed, $pkey_alias)
    {
		/* 如果字段为pkey别名，更改字段值为pkey */
		if ($pkey_alias != "" && $pkey_alias == $filed) {
			$filed = "pkey";
		}	
	
		$data = json_encode($array_data);
		$url = "http://".$server_host.":".$server_port."/?command=setindex&type=".$type."&filed=".$filed;
		$result = file_get_contents($url);
		return json_decode($result,true);
	}
}

/*********************************************
* 函数名：stripslashes_array($array)
* 函数用途：去除数组中的转义符号，例如有一个数组值为PHP序列化后的内容a:1:{s:7:\"message\";s:36:\"金山软件\";}，在TCSQL中存储的数据是经过转义的，如果需要在PHP中反序列化，则需要去掉转义符\
* 创建时间：2009-09-11
* 创建人：张宴
* 函数用法：
*     $array = array_map('stripslashes_array', $array);
* 参数说明：
*    $array   数组
* 返回值：
*    去除转义符后的数组
*********************************************/	
function stripslashes_array($array)
{
    $array = is_array($array) ?
                array_map('stripslashes_array', $array) :
                stripslashes($array);
    return $array;
}
?>

